-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.qDoneTown = false
    self.qDoneStone = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.qDoneValley = 0
			self.allQuests = 0
    end
  end
  
  if self.qDoneTown then
    self.p0:WinQuest('D09_THIRD_TOWN')
    self.p0:AddResource(8, 2500)
		self.allQuests = self.allQuests + 1
    self.qDoneTown = false
  end
  
  if self.qDoneValley == 3 then
    self.p0:WinQuest('D09_VALLEY')
		self.allQuests = self.allQuests + 1
    self.qDoneValley = 0
  end
  
  if self.qDoneStone then
    self.p0:WinQuest('D09_STONE')
    Debug:Log("Quest Stone Completed")
    self.p0:AddResource(2, 120)
    self.p0:AddResource(4, 80)
		self.allQuests = self.allQuests + 1
    self.qDoneStone = false
  end
  
	if self.allQuests == 3 then
		self.p0:UnlockCharacter("D_Earl-Ragnall")
		self.allQuests = 0
	end	
end

function OnTrigger(self, source, target)
  if target == "questThirdTown" then
    self.qDoneTown = true
  elseif target == "questStone" then
    self.qDoneStone = true
  elseif target == "questValley" then
    self.qDoneValley = self.qDoneValley + 1
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    self.loaded = true
    self.qDoneValley = ar:Read()
		self.allQuests = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.qDoneValley)
		ar:Write(self.allQuests)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("questThirdTown")
  self:AddTriggerTarget("questStone")
  self:AddTriggerTarget("questValley")
end
